#!/usr/bin/env python3

import sys, pygame, threading
import pygame.mixer, pygame.mouse
from xTimer import XTimer

lock = False
timer_tm = False
cmd = 0

current = 0.00
end = 60.00

current_str = None

score_red, score_green = 0, 0
is_red = True
is_score = True

pygame.mixer.init()

start_snd = pygame.mixer.Sound('timer_start.wav')
stop_snd = pygame.mixer.Sound('timer_stop.wav')
end_snd = pygame.mixer.Sound('timer_end.wav')
falstart_snd = pygame.mixer.Sound('timer_falstart.wav')

def timeout_timer():
	global current, end
	if (current <= end):
		current = current + 0.1

def play_end():
	global current, end, timer_tm
	while True:	
		if (current >= end) and (timer_tm):
			end_snd.play()
			timer_tm = False

black = (0, 0, 0)
white = (255, 255, 255)
red   = (255, 0, 0)
green = (0, 255, 0)

pygame.font.init()
pygame.display.init()

score_font = pygame.font.SysFont(None, 400)
timer_font = pygame.font.SysFont('Courier New', 250)

timer = XTimer(0.1, timeout_timer)
timer.init()
timer.start()
timer.pause()

check = threading.Thread(target=play_end)
check.start()

lscreen = pygame.Surface((640, 480))
rscreen = pygame.Surface((640, 480))
screen = pygame.display.set_mode((640, 480), pygame.FULLSCREEN)
pygame.event.set_allowed([pygame.MOUSEBUTTONDOWN, pygame.KEYDOWN])
pygame.mouse.set_visible(False)

r1 = pygame.Rect(310, 230, 20, 20)

while True:
	current_str = '{:.1f}'.format(current)
	lscreen.fill(black)
	if (is_red):
		pygame.draw.rect(lscreen, red, r1)
	else:
		pygame.draw.rect(lscreen, green, r1)
	for event in pygame.event.get():
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_RETURN):
			cmd = 0
			pygame.mixer.stop()
			lock = False
			timer.start()
			timer.run()
			timer_tm = True			
			start_snd.play()
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_SPACE):		
			cmd = 0
			pygame.mixer.stop()
			lock = False		
			timer.terminate()
			timer_tm = False
			current = 0.00
		if (event.type == pygame.MOUSEBUTTONDOWN) and (event.button == 3) and (not lock):
			if (timer_tm):
				cmd = 1
				timer.pause()
				pygame.mixer.stop()
				stop_snd.play()			
				lock = True
			else:
				cmd = 3
				timer.terminate()
				pygame.mixer.stop()
				falstart_snd.play()
				break
		if (event.type == pygame.MOUSEBUTTONDOWN) and (event.button == 2) and (not lock):
			if (timer_tm):
				cmd = 2
				timer.pause()
				pygame.mixer.stop()
				stop_snd.play()			
				lock = True
			else:
				cmd = 4
				timer.terminate()
				pygame.mixer.stop()
				falstart_snd.play()
				break
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_KP_DIVIDE):
			is_red = not is_red
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_KP_PLUS) and (is_red):
			score_red += 1
		elif (event.type == pygame.KEYDOWN) and (event.key == pygame.K_KP_PLUS) and not (is_red):
			score_green += 1
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_BACKSPACE):
			score_red = 0
			score_green = 0
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_KP_MULTIPLY):
			is_score = not is_score
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_ESCAPE):
			pygame.mixer.quit()
			pygame.display.quit()
			pygame.font.quit()
			sys.exit(0)
	if (cmd == 1):
		rscreen.fill(red)
	elif (cmd == 2):
		rscreen.fill(green)
	else:
		rscreen.fill(black)
	if (cmd == 3):
		zeit = timer_font.render(current_str, True, red)
	elif (cmd == 4):
		zeit = timer_font.render(current_str, True, green)
	else:
		zeit = timer_font.render(current_str, True, white)
	red_score = score_font.render(("%d" % score_red), True, red)
	green_score = score_font.render(("%d" % score_green), True, green)
	lscreen.blit(red_score, [(lscreen.get_width()//2 - red_score.get_width()) // 2, (lscreen.get_height() - red_score.get_height()) // 2])
	lscreen.blit(green_score, [((lscreen.get_width()//2 - green_score.get_width()) // 2)+lscreen.get_width()//2, (lscreen.get_height() - green_score.get_height()) // 2])
	rscreen.blit(zeit, [(rscreen.get_width()-zeit.get_width())//2, (rscreen.get_height()-zeit.get_height())//2])
	if (is_score):
		screen.blit(lscreen, [0, 0])
	else:	
		screen.blit(rscreen, [0, 0])
	pygame.display.update()
