#!/usr/bin/env python3

import sys, pygame, threading
import pygame.mixer, pygame.mouse
from time import time

lock = False
timer_tm = False
cmd = -1

current = 0.00
end = 60.00

current_str = None
last = 0.0
curr = time()

score_red, score_green = 0, 0
score_plus = 1
is_red = True
is_score = True

pygame.mixer.init()

start_snd = pygame.mixer.Sound('timer_start.wav')
stop_snd = pygame.mixer.Sound('timer_stop.wav')
end_snd = pygame.mixer.Sound('timer_end.wav')
falstart_snd = pygame.mixer.Sound('timer_falstart.wav')

def timer_control():
	global current, end, last, curr
	while True:
		if (timer_tm):
			if (current <= end):
				current = time()-curr + last
			if (current >= end):
				current = end
		elif (not timer_tm) and (not lock) and (cmd == -1):
			last = 0.00
			current = 0.00

def play_end():
	global current, end, timer_tm
	while True:	
		if (current >= end) and (timer_tm):
			end_snd.play()
			timer_tm = False

black = (0, 0, 0)
white = (255, 255, 255)
red   = (255, 0, 0)
green = (0, 255, 0)

pygame.font.init()
pygame.display.init()

score_font = pygame.font.SysFont(None, 400)
timer_font = pygame.font.SysFont('Courier New', 200)
small_font = pygame.font.SysFont('Courier New', 48)

ctrl = threading.Thread(target=timer_control)
ctrl.start()

check = threading.Thread(target=play_end)
check.start()

lscreen = pygame.Surface((640, 480))
rscreen = pygame.Surface((640, 480))
screen = pygame.display.set_mode((640, 480))#, pygame.FULLSCREEN)
pygame.event.set_allowed([pygame.MOUSEBUTTONDOWN, pygame.KEYDOWN])
pygame.mouse.set_visible(False)

r1 = pygame.Rect(310, 230, 20, 20)

while True:
	current_str = '{:.2f}'.format(current)
	lscreen.fill(black)
	if (is_red):
		pygame.draw.rect(lscreen, red, r1)
		score_timer = small_font.render(("{0}:{1}".format(str(score_red).rjust(2), str(score_green).ljust(2))), True, red)
	else:
		pygame.draw.rect(lscreen, green, r1)
		score_timer = small_font.render(("{0}:{1}".format(str(score_red).rjust(2), str(score_green).ljust(2))), True, green)
	for event in pygame.event.get():
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_RETURN):
			cmd = 0
			pygame.mixer.stop()
			lock = False
			last = current
			curr = time()
			timer_tm = True			
			start_snd.play()
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_SPACE):		
			cmd = -1
			pygame.mixer.stop()
			lock = False		
			timer_tm = False
			last = 0.00
			current = 0.00
		if (event.type == pygame.MOUSEBUTTONDOWN) and (event.button == 3) and (not lock):
			if (timer_tm):
				cmd = 1
				timer_tm = False
				pygame.mixer.stop()
				stop_snd.play()			
				lock = True
			else:
				cmd = 3
				pygame.mixer.stop()
				falstart_snd.play()
				break
		if (event.type == pygame.MOUSEBUTTONDOWN) and (event.button == 2) and (not lock):
			if (timer_tm):
				cmd = 2
				timer_tm = False
				pygame.mixer.stop()
				stop_snd.play()			
				lock = True
			else:
				cmd = 4
				pygame.mixer.stop()
				falstart_snd.play()
				break
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_KP_DIVIDE):
			is_red = not is_red
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_KP_PLUS) and (is_red):
			score_red += score_plus
			score_plus = 1
		elif (event.type == pygame.KEYDOWN) and (event.key == pygame.K_KP_PLUS) and not (is_red):
			score_green += score_plus
			score_plus = 1
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_LEFT):
			score_plus -= 1
			if (score_plus <= 0):
				score_plus = 1
		elif (event.type == pygame.KEYDOWN) and (event.key == pygame.K_RIGHT):
			score_plus += 1
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_BACKSPACE):
			score_red = 0
			score_green = 0
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_KP_MULTIPLY):
			is_score = not is_score
		if (event.type == pygame.KEYDOWN) and (event.key == pygame.K_ESCAPE):
			pygame.mixer.quit()
			pygame.display.quit()
			pygame.font.quit()
			sys.exit(0)
	if (cmd == 1):
		rscreen.fill(red)
	elif (cmd == 2):
		rscreen.fill(green)
	else:
		rscreen.fill(black)
	if (cmd == 3):
		zeit = timer_font.render(current_str, True, red)
	elif (cmd == 4):
		zeit = timer_font.render(current_str, True, green)
	else:
		zeit = timer_font.render(current_str, True, white)
	red_score = score_font.render(("%d" % score_red), True, red)
	green_score = score_font.render(("%d" % score_green), True, green)
	plus_score = small_font.render(("%d" % score_plus), True, white)
	lscreen.blit(red_score, [(lscreen.get_width()//2 - red_score.get_width()) // 2, (lscreen.get_height() - red_score.get_height()) // 2])
	lscreen.blit(green_score, [((lscreen.get_width()//2 - green_score.get_width()) // 2)+lscreen.get_width()//2, (lscreen.get_height() - green_score.get_height()) // 2])
	lscreen.blit(plus_score, [(lscreen.get_width()-plus_score.get_width())//2, 436])
	rscreen.blit(zeit, [(rscreen.get_width()-zeit.get_width())//2, (rscreen.get_height()-zeit.get_height())//2])
	if (not timer_tm) and (cmd == -1):
		rscreen.blit(plus_score, [(rscreen.get_width()-plus_score.get_width())//2, 436])
		rscreen.blit(score_timer, [(rscreen.get_width()-score_timer.get_width())//2, 388])
	if (is_score):
		screen.blit(lscreen, [0, 0])
	else:	
		screen.blit(rscreen, [0, 0])
	pygame.display.update()
